/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Fog
**
** DESCRIPTION:	Fog layer effect
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef FOG_H
#define FOG_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwTypes.h"
#include "ldwImage.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int Fog_c_iMaxFogLayers = 4;
const int Fog_c_iMaxFogCloudsPerLayer = 64;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CFog
{
private:

	//class structures
	struct SFog
	{
		float			m_fXPos;
		float			m_fYPos;
		float			m_fAlpha;
		unsigned int	m_uiFadeOffTime;
		bool			m_bIsFadingOn;
	};

	//class data
	SFog				m_Fog[Fog_c_iMaxFogLayers][Fog_c_iMaxFogCloudsPerLayer];
	ldwImage *			m_pFogImage;
	ldwPoint			m_sWorldPos;

	//class methods
	//setup
	public:		CFog();
	public:		~CFog();
	public:		void Reset();
	public:		void LoadAssets();
	public:		void ReleaseAssets();

	//process
	public:		void Update();
	public:		void Draw();
	public:		void Stop();

	//access
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CFog		Fog;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/